/*   The author of this code is Gonzalo Navarro, 1996.
     This code can be freely used and distributed for teaching and research
     purposes, provided it is not modified and this notice is kept attached.
     No part of this code can be used for direct or indirect commercial
     advantage without written permission of the author.
*/



#include <string.h>
#include "cut.h"
#include "lzgrep.h"




void makeCut (uchar *pattern, int m, int k, int jj, Cut *cut)

   { int i;
     int mdj,msj,mrj;

    PatternList.count = 0;
    PatternList.lmin = 0;
    PatternList.lmax = 0;
    PatternList.k = 0;
    PatternList.next_pattern = NULL;
    PatternList.last_pattern = NULL;
   

    PatternList.k = k/jj ;

     cut->j = jj; cut->k = k/jj;
     mdj = m/jj; 
     msj = (m+jj-1)/jj;   
     mrj = m-jj*mdj; 
    
      

          /* Partition in subpatterns */
     cut->aclen = ((int *) malloc ((1+jj)*sizeof(int)))+1;
     cut->len = (int*) malloc (jj*sizeof(int));
     cut->ps = (uchar**) malloc (jj*sizeof(uchar*));


     for (i=0;i<mrj;i++) 
	    cut->len[i] = msj;
     for (i=mrj;i<jj;i++) 
	    cut->len[i] = mdj;
     cut->aclen[-1] = 0;

     for (i=0;i<jj;i++)
         { 
           cut->aclen[i] = cut->aclen[i-1]+cut->len[i];
	   //  cut->len[i] = mdj;
           cut->ps[i] = (uchar*) malloc (cut->len[i]+1);
           strncpy (cut->ps[i],pattern+cut->aclen[i-1],cut->len[i]);
           cut->ps[i][cut->len[i]] = 0;
	   add_to_pattern_list_aprox(cut->ps[i],cut->len[i],cut->aclen[i]);
         }


 }

/////////////////////////////////////
static void add_to_pattern_list_aprox(char *str,int lenpat, int aclenpat) {
        TypePatternNode *pnode = NULL;
	char *s = strdup(str);
	char *p;
	int len;
        
	while (1) {
	  while (*s == '\n') s++;
	  if (*s == '\0') break;
	  pnode = PatternList.last_pattern;
	  if (pnode) {
	      pnode->next_pattern = (TypePatternNode *)malloc(sizeof(TypePatternNode));	
	      pnode = pnode->next_pattern;
	  } else  {
	      pnode = (TypePatternNode *)malloc(sizeof(TypePatternNode));
	      PatternList.next_pattern = pnode;
	  }
	  PatternList.last_pattern = pnode;
	  pnode->next_pattern = NULL;
	  pnode->pattern = s;
	  pnode->aclen = aclenpat;
	  pnode->len = lenpat;
	  pnode->pattern = s;
	  len = strlen(s);
	  if (!PatternList.count) {
		  PatternList.lmin = len;
		  PatternList.lmax = len;
	  } else {
		  if (PatternList.lmin > len)  PatternList.lmin = len;
		  if (PatternList.lmax < len)  PatternList.lmax = len;
          }
	  PatternList.count++;
	  s = strchr(s,'\n');
	  if (s == NULL) break;
	  *s = '\0';
	  s++;
     }
}

//////////////////////////////////////





void freeCut (Cut *cut)

   { int i;
     for (i=0; i<cut->j; i++)
        free (cut->ps[i]);
     free (cut->aclen-1); cut->aclen = NULL;
     free (cut->len); cut->len = NULL;
     free (cut->ps); cut->ps = NULL;
   }


