
typedef int bool;
#define true 1
#define false 0

typedef unsigned long mask;
typedef unsigned char uchar; 


#define Sigma 256  /*  size of the alphabet !!! */


#define AVANT 0
#define ARRIERE 1

#define TOTAL 1       /* pour le DAWG limite */
#define NONTOTAL 0

int newstate;


typedef int (*GAutom)[Sigma+6];

typedef struct 
   { int *d;			/* d table */
     GAutom G;			/* the aho-corasick of the patterns */
     GAutom DAWG;                  /* sufix automata of prefixes of the patterns */
     int minlen;		/* length of shorter pattern */
     int maxlen;                /* length of the longest one */
   } Multi;


/*************************/

int GZL_SIGMA;

#ifndef ENGLISH

#define GZL_chartoint(c) (((c) <= '9') ? ((c)-'/') : \
                         (((c) <= 'Z') ? ((c)+11-'@') :  \
                         (((c) <= 'z') ? ((c)+38-'a') : \
                                         ((c)+64-161))))
#define GZL_inttochar(i) ((unsigned char)(i + 2))
                        
#else

#define GZL_chartoint(c) ((c)=='\n') ? 0 : (((c)=='_') ? 1 : (((c) <= '9') ? ((c
)-'0'+2) : ((c)-'a'+11)))
#define GZL_inttochar(i) ((i)==0) ? '\n' : (((i)==1) ? '_' : (((i) <= 11) ? ((i)
-2+'0') : ((i)-11+'a')))

#endif







/************ construction de l'automate Aho-Corasick ********************/

/* niveau 0 -> suppleance+ -1 -> etat initial, -2 -> etat non utilise */
/* niveau 1 -> final ou pas et numero du pattern*/
/* niveau 2 -> fonction pere */
/* niveau 3 -> etiquette menant au pere */
/* niveau 4 -> calcul du shift du BDM */
/* niveau 5 -> calcul du plus long prefixe */


GAutom	MakeG(uchar **Ps, int r, int m)
   {
	int	i, j,state,pere,debut,lettre,dep=0;
	uchar * tmp;
	uchar carac;
        int * Dep = (int *) malloc((r+1)*sizeof(int));  /*  place de debut des motifs ds l"'autoamte */
        GAutom G = (GAutom) malloc ((m+r+1)*sizeof(*G));

        newstate = 0;

	for ( i = 0; i <= m+r; i++ ) {
	  G[i][0]=0;  /* suppleance */
	  for ( j = 1; j < Sigma+6; j++ )
	    G[i][j] = -1;
	}
	
	G[0][0]=-1;  /* suppleance de l'etat initial */
	G[0][2]=-1; /* pere de l'etat 0 */
	G[0][5]=0;   ////esto es lo que cambia en aho-co
	
	Dep[0]=1;  /* debut de la lecture du premier etat */
	for ( i = 0; i < r; i++) {
	  debut=Dep[i];
	  tmp = Ps[i];  /* ieme motif */
	  state=0;
	  lettre=0;
	  while (G[state][tmp[lettre]+6]!=-1) {
	    G[debut++][0]=-2;   /* etat inutilise (pour le parcours en largeur) */
	    state=G[state][tmp[lettre++]+6];
	  }
	  if (tmp[lettre]==0) {
	    G[state][1]=i+1;  /* etat terminal et numero du motif ! */
	    Dep[i+1]=debut;
	  }
	  else {
	    
	    G[state][tmp[lettre]+6]=debut;   /* on saute au premier etat non utilise */
	    G[debut][2]=state;                 /* le pere */
	    G[debut][3]=(int) tmp[lettre++];   /* la lettre de la transition du pere */ 
	    G[debut][5]=lettre;
	    while (tmp[lettre]!=0) {	      
	      G[debut][tmp[lettre]+6]=++debut;  /* nouvel etat */ 
	      G[debut][2]=debut-1;                /* pere */
	      G[debut][3]=(int)tmp[lettre++];     /* la lettre de la transition au pere */
	      G[debut][5]=lettre;
	    }
	    G[debut][1]=i+1; /* etat terminal */
	    Dep[i+1]=debut+1;  /* etat de debut pour le motif suivant */
	  }
	}  /* fin de la construction basique de l'automate -> a verifier */
	/* calcul de la fonction de suppleance par un parcours en largeur !!! */

	debut=1;
	i=0;
	while (debut) {
	  debut=0;
	  for (j=0;j<r;j++) {
	    if (i<=strlen(Ps[j])) {
	      debut=1;
	      state=Dep[j]+i;   /* etat dont on veut calculer la fonction de suppleance */
	      if (G[state][0]!=-2) {
		pere = G[state][2];
		if (pere>0) {  /* le supplenat est a 0 au debut */
		  carac=(uchar)G[state][3];
		  pere=G[pere][0];   /* on prend le suppleant du pere */
		  while (pere>-1 && G[pere][carac+6]==-1) pere=G[pere][0];
		  if (pere==-1) G[state][0]=0;  /* si pas de transition suffixe -> on revient a 0 */
		  else {
		    G[state][0]=G[pere][carac+6]; /* sinon on fixe la transition de suppleance */
		    if (G[(G[state][0])][1]>0) G[state][1]=G[(G[state][0])][1]; /* on fixe les terminaux */
		  }						 
		}  /* fin du si le pere existe */
	      } /* fin de traitement si l'etat n'est pas factice (vide) */
	    } /* fin du i */
	  } /* fin du parcours sur j */
	  i++;
	}  /* fin du tant que debut -> si on est encore dans le parcours en largeur */

	
	return G;
   }




/******************************* ORACLE automaton of the prefixes of the patterns ************************/

/* remember de la table
   0 -> supleance
   1 -> Etat final ou non
   2 -> Longueur maximum
   3 -> clone ou pas
   4 -> longueur min
   5 -> etat Ac de la longueur min */


GAutom	MakeORAC(uchar **Ps, int r, int m,int minlen)
   {
	int	i, j,state,pere,debut,lettre,dep=0;
	uchar * tmp;
	uchar carac;
        int * Dep = (int *) malloc((r+1)*sizeof(int));  /*  place de debut des motifs ds l"'autoamte */
        GAutom G = (GAutom) malloc ((m+r+1)*sizeof(*G));

        newstate = 0;

	for ( i = 0; i <= m+r; i++ ) {
	  G[i][0]=0;  /* suppleance */
	  for ( j = 1; j < Sigma+6; j++ )
	    G[i][j] = -1;
	}
	
	G[0][0]=-1;  /* suppleance de l'etat initial */
	G[0][2]=-1; /* pere de l'etat 0 */
	G[0][5]=0;
	
	Dep[0]=1;  /* debut de la lecture du premier etat */
	
	for ( i = 0; i < r; i++) {
	  debut=Dep[i];
	  tmp = Ps[i];  /* ieme motif */
	  state=0;
	  lettre=minlen-1;
	  while (lettre>=0 && G[state][tmp[lettre--]+6]!=-1) {
	    G[debut++][0]=-2;   /* etat inutilise (pour le parcours en largeur) */
	    state=G[state][tmp[lettre+1]+6];
	  }
	  if (tmp[++lettre]==0) G[state][1]=i+1;  /* etat terminal et numero du motif ! */
	  else {
	    
	    G[state][tmp[lettre--]+6]=debut;   /* on saute au premier etat non utilise */
	    G[debut][2]=state;                 /* le pere */
	    G[debut][3]=(int) tmp[lettre+1];   /* la lettre de la transition du pere */ 
	    G[debut][5]=lettre;
	    while (lettre >= 0) { /*  tmp[lettre]!=0) { */
	      debut++;
	      G[debut-1][tmp[lettre--]+6]=debut;  /* nouvel etat */ 
	      G[debut][2]=debut-1;                /* pere */
	      G[debut][3]=(int)tmp[lettre+1];     /* la lettre de la transition au pere */
	      G[debut][5]=lettre;
	    }
	    G[debut][1]=i+1; /* etat terminal */
	    Dep[i+1]=debut+1;  /* etat de debut pour le motif suivant */
	  }
	}  /* fin de la construction basique de l'automate -> a verifier */
	
	/* calcul de la fonction de suppleance par un parcours en largeur !!! */

	debut=1;
	i=0;
	while (debut) {
	  debut=0;
	  for (j=0;j<r;j++) {
	    if (i<minlen) {
	      debut=1;
	      state=Dep[j]+i;   /* etat dont on veut calculer la fonction de suppleance */
	      if (G[state][0]!=-2) {
		pere = G[state][2];
		if (pere>0) {  /* le supplenat est a 0 au debut */
		  carac=(uchar)G[state][3];
		  pere=G[pere][0];   /* on prend le suppleant du pere */
		  while (pere>-1 && G[pere][carac+6]==-1) {
		    G[pere][carac+6]=state;
		    pere=G[pere][0];
		  }
		  if (pere==-1) G[state][0]=0;  /* si pas de transition suffixe -> on revient a 0 */
		  else {
		    G[state][0]=G[pere][carac+6]; /* sinon on fixe la transition de suppleance */
		  }						 
		}  /* fin du si le pere existe */
	      } /* fin de traitement si l'etat n'est pas factice (vide) */
	    } /* fin du i */
	  } /* fin du parcours sur j */
	  i++;
	}  /* fin du tant que debut -> si on est encore dans le parcours en largeur */

	for (j=0;j<r;j++) {    /* marquage des etats terminaux */
	  state = Dep[j]+minlen-1;
	  if (G[state][0]!=-2) {
		pere = G[state][0];
		while (pere>-1 && G[pere][1]==-1) {
		  G[pere][1]=1;
		  pere=G[pere][0];
		}		
	  }
	}	
	return G;
   }




/* remember de la table
 0 -> supleance
 1 -> Etat final ou non
 2 -> Longueur maximum
 3 -> clone ou pas
 4 -> longueur min
 5 -> etat Ac de la longueur min */


/* prepare to search patterns Ps[0]..Ps[r-1] */

void prepMulti (Multi *M, uchar **Ps, int r, int jj)

  { int c,i,j,totlen;

    /* compute the total and minimum length */
    M->minlen = totlen = strlen(Ps[0]);
    for (i=1;i<r;i++)
	{ int l = strlen(Ps[i]);
	  totlen += l;
	  if (l < M->minlen) M->minlen = l;
	}
    
	/* compute the trie */
    M->G = MakeG (Ps,r,totlen);
    M->DAWG=MakeORAC(Ps,r,totlen,M->minlen);
  }



void initMulti (Multi *M)

  {
  }

	/* free data */

void freeMulti (Multi *M)

   { 
     free (M->G); M->G = NULL;
     free (M->DAWG); M->DAWG= NULL;
   }

	/* searches M from text+n, returning where was it found (next position)
	   (the pattern must be in the text)
	*/
