
// Codificacion Huffman para bytes

#ifndef HUFFINCLUDED
#define HUFFINCLUDED

#include "bits.h"

typedef struct sHT
   { uchar c;
     int freq;
     int left;
     int right;
   } *HT;  // celda del arbol de Huffman (necesita 512 celdas)

typedef struct shcode
   { ulong code[256/W]; // hasta 256 bits
     int len;
   } *hcode;  // un codigo de Huffman

// recibe frecuencias y entrega el arbol y los codigos
// se codifica con codes[char]
void createHuffCodes (int *freqs, HT tree, hcode codes);

// escribe el arbol al bitstream, invocar con tpos = 0
void writeHuffTree (HT tree, bitstream B);

// lee el arbol del bitstream
void readHuffTree (HT tree, bitstream B);

// codifica el hcode en el bitstream
void codeHuff (struct shcode *code, bitstream B);

// entrega el sgte caracter del bitstream
uchar decodeHuff (HT tree, bitstream B);

#endif
