
#ifndef BITSINCLUDED
#define BITSINCLUDED

// Manipula streams de bits

#include "basics.h"

typedef struct sBitstream
   { ulong *stream;
     int pos;     // pos cursor en words
     int bpos;    // bit cursor para last
     ulong last;  // ultima word esta aqui
   } *bitstream;

   // crea para escritura
bitstream createbits (int bytes);
   // crea para lectura, comparte stream
bitstream readfrom (uchar *stream);
   // bits necesarios para codificar x
int bits (uint x);
   // agrega n bits de x al cursor (lowest)
void addbits (bitstream B, ulong x, int n);
   // lee n bits del cursor
ulong getbits (bitstream B, int n);
   // lee 1 bit del cursor
int getbit (bitstream B);
   // agrega nro x en el cursor
void adddelta (bitstream B, int x);
   // lee sgte nro del cursor
int getdelta (bitstream B);
   // cierra la escritura, libera, y entrega el nro de bytes y un puntero al 
   // array, que debe ser liberado por el invocante
uchar *closebits (bitstream B, int *n);
   // cierra la lectura
void deletebits (bitstream B);

#endif
