
#include "sort.h"

	/* should be replaced by something more efficient */

static void sasort (uint *array, uchar *text, int lo, int up)

   { int i,j;
     uchar *tempr;
     while (up>lo) 
	{ i = lo;
          j = up;
          tempr = text + array[lo];
          while (i<j) 
	      { while ((i<j) && strcmp(text+array[j],tempr) > 0) j--; 
                array[i]=array[j]; 
		while ((i<j) && strcmp(text+array[i],tempr)<=0) i++;
                array[j] = array[i];
              }
          array[i] = tempr - text;
          if (i-lo < up-i) 
	       { sasort (array,text,lo,i-1);  lo = i+1; }
          else { sasort (array,text,i+1,up);  up = i-1; }
        }
    }

sarray sacreate (uchar *text, int n, int pblock)

   { uint i;
     sarray S;
     uint *array;
     S.n = n; S.text = text;
     array = malloc ((n+1)*sizeof(uint)); 
     S.L = malloc ((n+1)*sizeof(uchar));
     for (i=0;i<=n;i++) array[i] = i;
     sasort (array,text,0,n);
     for (i=0;i<256;i++) S.freq[i] = 0;
     for (i=0;i<=n;i++) 
	 { if (array[i] == 0) S.L[i] = S.text[n];
	   else S.L[i] = S.text[array[i]-1];
	   S.freq[S.L[i]]++;
	 }
     S.invmap = malloc (((n+1+pblock-1)/pblock)*sizeof(uint));
     for (i=0;i<=n;i++)
	if (!(array[i] % pblock))
	   S.invmap[array[i]/pblock] = i;
     free (array);
     return S;
   }

void safree (sarray S)

   { free (S.L);
     free (S.invmap);
   }

