
#include "huff.h"

static void writecodes (HT tree, int tpos, struct shcode *curr, hcode codes)

   { if (tree[tpos].left == -1)
	{ codes[tree[tpos].c] = *curr;
	}
     else
	{ curr->len++;
	  curr->code[(curr->len-1)/W] &= ~(1 << ((curr->len-1) % W));
	  writecodes (tree,tree[tpos].left,curr,codes);
	  curr->code[(curr->len-1)/W] |= 1 << ((curr->len-1) % W);
	  writecodes (tree,tree[tpos].right,curr,codes);
	  curr->code[(curr->len-1)/W] &= ~(1 << ((curr->len-1) % W));
	  curr->len--;
	}
   }

void createHuffCodes (int *freqs, HT tree, hcode codes)

   { int i,j,k,min,N;
     struct sHT node[256];
     struct sHT aux;
     struct shcode curr;
  
     j = 0;
     for (i=0;i<256;i++)
	if (freqs[i])
	   { node[j].c = i;
             node[j].freq = freqs[i];
             node[j].left = -1;
             node[j].right = -1;
	     j++;
           }
     N = j;

     if (N==0)  // crear nodo dummy
        { N=1; 
	  node[0].c = 0;
          node[0].freq = 0;
          node[0].left = -1;
          node[0].right = -1;
	}

     for (i=N-1;i>0;i--)
	{ k = i; min = node[i].freq;
	  for (j=0;j<i;j++)
	      if (node[j].freq < min) { k = j; min = node[k].freq; }
	  if (k != i)
	     { aux = node[i]; node[i] = node[k]; node[k] = aux; }
	}

     j = 1; i = N-1;
     while (i>0)
	{ tree[j++] = node[i--];
	  tree[j++] = node[i];
	  aux.freq = node[i].freq + node[i+1].freq;
	  aux.left = j-2;
	  aux.right = j-1;
	  k = i;
	  while ((k>0) && (node[k-1].freq < aux.freq))
	     { node[k] = node[k-1]; k--; }
	  node[k] = aux;
	}
     tree[0] = node[0];

     curr.len = 0;
     for (i=0;i<256/W;i++) curr.code[i] = 0;
     writecodes (tree, 0, &curr, codes);
   }

static void writetree (HT tree, int tpos, bitstream B)

   { if (tree[tpos].left == -1) // hoja
	{ addbits (B,0,1);
	  addbits (B,tree[tpos].c,8);
	}
     else
	{ addbits (B,1,1);
	  writetree (tree,tree[tpos].left,B);
	  writetree (tree,tree[tpos].right,B);
	}
   }

void writeHuffTree (HT tree, bitstream B)

   { writetree (tree,0,B);
   }

static int readtree (HT tree, int tpos, bitstream B)

   { int h;
     h = getbit (B);
     if (!h) // hoja
        { tree[tpos].c = getbits (B,8);
	  tree[tpos].left = -1;
	  tree[tpos].right = -1;
	  return tpos+1;
	}
     else
	{ tree[tpos].left = tpos+1;
          tree[tpos].right = readtree (tree,tpos+1,B);
	  return readtree (tree,tree[tpos].right,B);
	}
   }

void readHuffTree (HT tree, bitstream B)

   { readtree (tree, 0, B);
   }

uchar decodeHuff (HT tree, bitstream B)

   { int dir;
     int tpos = 0;
     while (tree[tpos].left != -1) 
        { dir = getbit (B);
          if (dir == 0) tpos = tree[tpos].left;
          else          tpos = tree[tpos].right;
	}
     return tree[tpos].c;
   }

void codeHuff (struct shcode *code, bitstream B)

   { int len = code->len;
     int pos = 0;
     int dlen;
     while (len)
       { dlen = len; if (dlen > W) dlen = W;
	 addbits (B,code->code[pos++],dlen);
	 len -= dlen;
       }
   }
