
#include "basics.h"
#include "mtf.h"
#include "bits.h"
#include "huff.h"

static void txtload (char *fname, uchar **text, uint *n, 
		int *on, uchar *sorted, int *alphn)

   { int f;
     struct stat sdata;

        /* read the file into memory */
     if (stat(fname,&sdata) != 0)
        { fprintf (stderr,"Cannot stat file %s\n",fname);
	  exit(1);
        }

     f = open (fname,O_RDONLY);
     if (f == -1)
        { fprintf (stderr,"Cannot open file %s\n",fname);
	  exit(1);
        }

     if (read(f,on,sizeof(int)) != sizeof(int))
        { fprintf (stderr,"Cannot read file %s\n",fname);
	  exit(1);
        }

     if (read(f,alphn,sizeof(int)) != sizeof(int))
        { fprintf (stderr,"Cannot read file %s\n",fname);
	  exit(1);
        }

     if (read(f,sorted,*alphn) != *alphn)
        { fprintf (stderr,"Cannot read file %s\n",fname);
	  exit(1);
        }

     *n = sdata.st_size - 2*sizeof(int) - *alphn;
     *text = (uchar*) malloc (*n);

     if (read(f,*text,*n) != *n)
        { fprintf (stderr,"Cannot read file %s\n",fname);
	  exit(1);
        }

     close (f);
   }

static void txtsave (char *fname, uchar *text, uint n)

   { int f;
     struct stat sdata;

     if ((f = creat(fname,S_IRUSR|S_IWUSR)) == -1)
        { fprintf (stderr,"Cannot create file %s\n",fname);
          exit(1);
        }

     if (write(f,text,n) != n)
        { fprintf (stderr,"Cannot write file %s\n",fname);
          exit(1);
        }

     if (close(f) != 0)
        { fprintf (stderr,"Cannot write file %s\n",fname);
          exit(1);
        }
   }

main (int argc, char **argv)

   { uchar *L,*ctext,*text,c;
     char cfile[1024];
     int d,i,j,cn,n,run,alphn;
     int freq[256],C[256];
     uchar sorted[256];
     int *LF;
     MTF M;
     bitstream B;
     struct sHT treec[512],treer[512];
     
     if (argc != 2)
	{ fprintf(stderr,"Usage: main <comprfile>\n");
	  exit(1);
	}

     sprintf (cfile,"%s.bwt",argv[1]);
     txtload (cfile,&ctext,&cn,&n,sorted,&alphn);
     L = malloc (n+1);
     
	// decodifico L
     M = initMTF (sorted,alphn);
     B = readfrom (ctext);

     readHuffTree (treec,B);
     readHuffTree (treer,B);

     for (i=0;i<=n;i++)
	{ if (!(i % block)) reinitMTF(M);
	  d = decodeHuff(treec,B);
	  c = givenMTF(M,d);
	  L[i] = c;
	  if (d == 0) 
	     { run = decodeHuff(treer,B);
	       while (run--) L[++i] = c;
	     }
	}
exit(1);
     
     deletebits(B); free (ctext);

	// creo text a partir de L
     text = malloc (n+1);
     LF = malloc ((n+1)*sizeof(int));

     for (i=0;i<256;i++) freq[i] = 0;
     for (i=0;i<=n;i++) freq[L[i]]++;
     C[0] = 0; freq[255] = 0;
     for (i=1;i<256;i++) 
	 { C[i] = C[i-1] + freq[i-1];
	   freq[i-1] = 0;
	  }
     for (i=0;i<=n;i++)
	 { LF[i] = C[L[i]] + freq[L[i]];
	   freq[L[i]]++;
	 }

     j = 0;
     for (i=n-1;i>=0;i--)
	{ text[i] = L[j];
	  j = LF[j];
	}

     txtsave (argv[1],text,n);

     fprintf (stderr,"Uncompressed\n");
     exit(0);
   }

