
int Mem=0;

#define madd(t,n) { Mem += (n); printf ("%s, Mem = %i\n",t,Mem); }
#define msub(t,n) { Mem -= (n); printf ("%s, Mem = %i\n",t,Mem); }

struct tms time1,time2;
double ticks;

// codigo para el caso en que el texto y las estructuras entran en memoria

#include "basics.h"
#include "mtf.h"
#include "bits.h"
#include "huff.h"
#include "hash.h"

#define BRK '\n'

static void txtload (char *fname, uchar **text, uint *n, 
		int *on, uchar *sorted, int *alphn)

   { int f;
     struct stat sdata;

        /* read the file into memory */
     if (stat(fname,&sdata) != 0)
        { fprintf (stderr,"Cannot stat file %s\n",fname);
	  exit(1);
        }

     f = open (fname,O_RDONLY);
     if (f == -1)
        { fprintf (stderr,"Cannot open file %s\n",fname);
	  exit(1);
        }

     if (read(f,on,sizeof(int)) != sizeof(int))
        { fprintf (stderr,"Cannot read file %s\n",fname);
	  exit(1);
        }

     if (read(f,alphn,sizeof(int)) != sizeof(int))
        { fprintf (stderr,"Cannot read file %s\n",fname);
	  exit(1);
        }

     if (read(f,sorted,*alphn) != *alphn)
        { fprintf (stderr,"Cannot read file %s\n",fname);
	  exit(1);
        }

     *n = sdata.st_size - 2*sizeof(int) - *alphn;
     *text = (uchar*) malloc (*n);
madd("permuted text", *n);

     if (read(f,*text,*n) != *n)
        { fprintf (stderr,"Cannot read file %s\n",fname);
	  exit(1);
        }

     close (f);
   }

static int ptrload (char *fname, uint **invmap, uint *pblock)

   { int f,n;
     struct stat sdata;

        /* read the file into memory */
     if (stat(fname,&sdata) != 0) return 0;

     f = open (fname,O_RDONLY);
     if (f == -1)
        { fprintf (stderr,"Cannot open file %s\n",fname);
	  exit(1);
        }

     if (read(f,pblock,sizeof(int)) != sizeof(int))
        { fprintf (stderr,"Cannot read file %s\n",fname);
	  exit(1);
        }

     n = (sdata.st_size - sizeof(int))/sizeof(int);
     *invmap = (int*) malloc (n*sizeof(int));
madd ("sarray map", n*sizeof(int));

     if (read(f,*invmap,n*sizeof(int)) != n*sizeof(int))
        { fprintf (stderr,"Cannot read file %s\n",fname);
	  exit(1);
        }

     close (f);
     return 1;
   }

static void freqload (char *fname, int n, uchar *sorted, int alphn,
		      ulong *C, ulong **SOcc, ulong **SPos, uchar **PosData)

   { int i,f,c,j,N;
     struct stat sdata;
     ushort sdat;
     uint dat;
     ulong acc;

        /* read the file into memory */
     if (stat(fname,&sdata) != 0) 
        { fprintf (stderr,"Cannot stat file %s\n",fname);
	  exit(1);
        }

     f = open (fname,O_RDONLY);
     if (f == -1)
        { fprintf (stderr,"Cannot open file %s\n",fname);
	  exit(1);
        }

     for (i=0;i<256;i++) SOcc[i] = NULL;
     for (i=0;i<alphn;i++)
	{ c = sorted[i];
	  SOcc[c] = malloc ((2+(n>>bitssblock))*sizeof(ulong));
	  SPos[c] = malloc ((2+(n>>bitssblock))*sizeof(ulong));
madd("block directory", 2*(2+(n>>bitssblock))*sizeof(ulong));
	}
     for (i=0;i<alphn;i++)
	{ c = sorted[i];
	  SOcc[c][0] = 0;
	  for (j=0;j<=n>>bitssblock;j++)
              { if (read(f,&dat,sizeof(uint)) != sizeof(uint))
                   { fprintf (stderr,"Cannot read file %s\n",fname);
                     exit(1);
                   }
		SOcc[c][j+1] = SOcc[c][j] + dat;
              }
        }

     C[0] = 0;
     for (i=1;i<256;i++) 
	{ C[i] = C[i-1];
	  if (SOcc[i-1]) C[i] += SOcc[i-1][1+(n>>bitssblock)];
        }
     for (i=0;i<alphn;i++)
	{ int d;
	  c = sorted[i];
	  d = C[c];
	  for (j=0;j<=1+(n>>bitssblock);j++) SOcc[c][j] += d;
	}

     acc = 0;
     for (i=0;i<alphn;i++)
	{ c = sorted[i];
	  SPos[c][0] = acc;
	  for (j=0;j<=n>>bitssblock;j++)
              { if (read(f,&sdat,sizeof(ushort)) != sizeof(ushort))
                   { fprintf (stderr,"Cannot read file %s\n",fname);
                     exit(1);
                   }
		SPos[c][j+1] = SPos[c][j] + sdat;
              }
	  acc = SPos[c][j];
        }

     N = (sdata.st_size - alphn*(1+(n>>bitssblock))*
		(sizeof(uint)+sizeof(ushort))) / sizeof(uchar);
     *PosData = malloc (N*sizeof(uchar));
madd ("block directory",N*sizeof(uchar));

     if (read(f,*PosData,N*sizeof(uchar)) != N*sizeof(uchar))
        { fprintf (stderr,"Cannot read file %s\n",fname);
	  exit(1);
        }
     close (f);
   }

int count (register uchar *text, int n, register uchar c)

   { register uchar *fin = text+n;
     register int tot = 0;
     while (text != fin)
	if (*text++ == c) tot++;
     return tot;
   }

#define Occ(c,blk) (SOcc[c][(blk)>>bbitssblock] + \
		    accpos(PosData+SPos[c][(blk)>>bbitssblock],blockof(blk)))

int accpos (register uchar *text, register int n)

   { register int tot = 0;
     register int val;
     while (n-- > 0)
	{ val = *text++;
	  if (val) tot += val;
	  else { val = *text++;
		 if (val) n -= val-1;
		 else tot += 256;
	       }
	}
     return tot;
   }

main (int argc, char **argv)

   { uchar *L,*ctext,c;
     char cfile[1024];
     int d,i,j,cn,n,run,alphn;
     uchar sorted[256];
     MTF M;
     bitstream B;
     struct sHT treec[512],treer[512];
     ulong C[256];
     ulong *SOcc[256];
     ulong *SPos[256];
     uchar *PosData;
     uchar patt[1024];
     int ub,lb,m;
     uint *invmap,pblock;
     Hash map;
     int ptrs,level;
     uchar liner[1024];
     
     if (argc != 2)
	{ fprintf(stderr,"Usage: bwts <comprfile>\n");
	  exit(1);
	}

     sprintf (cfile,"%s.bwt",argv[1]);
     txtload (cfile,&ctext,&cn,&n,sorted,&alphn);
     sprintf (cfile,"%s.bwf",argv[1]);
     freqload (cfile,n,sorted,alphn,C,SOcc,SPos,&PosData);
     sprintf (cfile,"%s.bwp",argv[1]);
     ptrs = ptrload (cfile,&invmap,&pblock);
     if (!ptrs) fprintf(stderr,"No pointers -- can only count occurrences\n");
     map = loadhash (invmap,(n+1+pblock-1)/pblock,2.0);
     L = malloc (n+1);
madd ("permuted text", n+1);
     
	// decodifico L
     M = initMTF (sorted,alphn);
     B = readfrom (ctext);

     readHuffTree (treec,B);
     readHuffTree (treer,B);

     for (i=0;i<=n;i++)
	{ if (!(i % block)) reinitMTF(M);
	  d = decodeHuff(treec,B);
	  c = givenMTF(M,d);
	  L[i] = c;
	  if (d == 0) 
	     { run = decodeHuff(treer,B);
	       while (run--) L[++i] = c;
	     }
	}
     
     deletebits(B); free (ctext);
msub("permuted text", cn);


     printf ("Ready to search, enter patterns\n");

	// busquedas
     ticks= (double)sysconf(_SC_CLK_TCK);
     times(&time1);

     while (1)
	{ m = 0; while ((patt[m++] = getchar()) != '\n');
	  patt[--m] = 0;
	  if (!strcmp(patt,"END")) break;
	  if (ptrs) level = 2; else level = 0;
	  if ((patt[0]=='c') && (patt[1]==':')) 
	     { level = 0; strcpy(patt,patt+2); }
	  else if ((patt[0]=='p') && (patt[1]==':')) 
	     { strcpy(patt,patt+2); 
	       if (ptrs) level = 1;
	     }
	  m = strlen(patt)-1;
	  lb = C[patt[m]]; ub = C[patt[m]+1];
	  while ((lb < ub) && (--m >= 0))
	     { int ob,lbn,ubn,lbb,ubb;
               if (!SOcc[patt[m]]) // char not in text
		  { lb = ub = C[patt[m]]; break; }
	       lbn = lb>>bitsblock;
	       lbb = lbn<<bitsblock;
	       ubn = ub>>bitsblock;
	       ubb = ubn<<bitsblock;
	       if ((lbn == ubn) && ((lb-lbb > ub-lb) | (lbb+block-ub > ub-lb)))
			// ambos en el mismo block y vale la pena
		  { if (lb-lbb <= lbb+block-ub)
		       { ob = lb;
			 lb = Occ(patt[m],lbn) + count(L+lbb,lb-lbb,patt[m]);
		         ub = lb + count(L+ob,ub-ob,patt[m]);
		       }
		    else
	               { ob = ub;
		         ub = Occ(patt[m],lbn+1) -
			      count(L+ub,ubb+block-ub,patt[m]);
		         lb = ub - count(L+lb,ob-lb,patt[m]);
		       }
		  }
               else 
		  { if (lb-lbb <= hblock)
		         lb = Occ(patt[m],lbn) + count(L+lbb,lb-lbb,patt[m]);
		    else lb = Occ(patt[m],lbn+1) -
			      count(L+lb,lbb+block-lb,patt[m]);
		    if (ub-ubb <= hblock)
		         ub = Occ(patt[m],ubn) + count(L+ubb,ub-ubb,patt[m]);
		    else ub = Occ(patt[m],ubn+1) -
			      count(L+ub,ubb+block-ub,patt[m]);
		  }
	     }
	  printf ("%s: %i occurrences: [%i,%i]\n",patt,
		   ub-lb >= 0 ? ub-lb : 0,lb,ub-1);

	  if (level == 0) continue; // no mostrar las posiciones
	  while (lb < ub)
	     { int offs = 0;
	       int ptr,optr;
	       int h,bn,bb,brk=-1;
	       ptr = optr = lb;
	       while ((h=hash(map,ptr)) == -1)
		  { bn = ptr>>bitsblock;
		    bb = bn<<bitsblock;
		    c = L[ptr];
		    if (brk == -1) // realmente es para level 2
		       { if (c == BRK) brk = offs; 
			 else liner[offs] = c;
		       }
		    offs++;
		    if (ptr-bb <= hblock)
		         ptr = Occ(c,bn) + count(L+bb,ptr-bb,c);
		    else ptr = Occ(c,bn+1) - count(L+ptr,bb+block-ptr,c);
		  }
	       printf ("Position: %i\n",h*pblock+offs);
	       lb++;

	       if (level == 1) continue; // no mostrar el texto

	       if (brk == -1)
	          while (1)
		    { c = L[ptr];
		      if ((c == 0) || (c == BRK)) { brk = offs; break; }
		      liner[offs++] = c;
		      bn = ptr>>bitsblock;
		      bb = bn<<bitsblock;
		      if (ptr-bb <= hblock)
		           ptr = Occ(c,bn) + count(L+bb,ptr-bb,c);
		      else ptr = Occ(c,bn+1) - count(L+ptr,bb+block-ptr,c);
		    }
	       while (--brk >= 0) putchar (liner[brk]);
	       while (brk == -1)
	         { int noptr;
		   if ((h+1)*pblock <= n) ptr = invmap[h+1]; else ptr = 0;
		   offs = 0; noptr = ptr;
	           while (ptr != optr)
	              { bn = ptr>>bitsblock;
	                bb = bn<<bitsblock;
		        c = L[ptr];
		        if (c == BRK) brk = offs = 0; 
			else liner[offs++] = c;
		        if (ptr-bb <= hblock)
		             ptr = Occ(c,bn) + count(L+bb,ptr-bb,c);
		        else ptr = Occ(c,bn+1) - count(L+ptr,bb+block-ptr,c);
		      }
		   while (--offs >= 0) putchar (liner[offs]);
		   optr = noptr;
		   if (noptr == 0) brk = 0; else h++;
		 }
	       putchar ('\n');
	     }
	}

     times (&time2);
     fprintf (stderr,"Query time: %f\n",(time2.tms_utime - time1.tms_utime)/ticks);

     exit(0);
   }

