
#include "bits.h"

   // crea para escritura
bitstream createbits (int bits)

   { bitstream B = malloc (sizeof(struct sBitstream));
     B->stream = (ulong*) malloc ((bits+W-1)/8);
     B->pos = 0;
     B->bpos = 0;
     B->last = 0;
     return B;
   }

   // crea para lectura
bitstream readfrom (uchar *stream)

   { bitstream B = malloc (sizeof(struct sBitstream));
     B->stream = (ulong*) stream;
     B->bpos = 0;
     B->last = B->stream[0];
     B->pos = 1;
     return B;
   }

   // borra la de lectura
void deletebits (bitstream B)

   { free (B);
   }

   // agrega bits en el cursor

void addbits (bitstream B, ulong x, int n)

   { B->last |= x << B->bpos;
     B->bpos += n; 
     if (B->bpos >= W)
	{ B->stream[B->pos++] = B->last;
	  B->bpos -= W;
	  B->last = B->bpos ? x >> (n-B->bpos) : 0;
	}
   }

   // lee bits del cursor

ulong getbits (bitstream B, int n)

   { ulong x = B->last >> B->bpos;
     B->bpos += n;
     if (B->bpos >= W)
	{ B->last = B->stream[B->pos++];
	  B->bpos -= W;
	  x |= B->last << (n-B->bpos);
	}
     if (n == W) return x; else return x & ((1<<n)-1);
   }
	  
int getbit (bitstream B)

   { int x = B->last & (1<<(B->bpos++));
     if (B->bpos == W)
	{ B->last = B->stream[B->pos++];
	  B->bpos = 0;
	}
     return x != 0;
   }
	  
    // agrega x en codif delta

int bits (uint x)

   { int b=0;
     while (x) { b++; x>>=1;}
     return b;
   }

    
void adddelta (bitstream B, int x) // permite los ceros

   { int b = bits(x+1);
     int l = (1<<(b-1))-1;
     addbits (B,l,b);
     x = (x+1) & ~(1<<(b-1));
     addbits (B,x,b-1);
   }

   // lee sgte nro del cursor, formato delta

int getdelta (bitstream B)

   { int bits = 0;
     uint x,i;
      // 1ero obtener el nro de bits (-1)
     while (B->last & (1<<(B->bpos++)))
	{ bits++;
	  if (B->bpos == W)
	     { B->last = B->stream[B->pos++];
	       B->bpos = 0;
	     }
	}
     if (B->bpos == W)
	{ B->last = B->stream[B->pos++];
	  B->bpos = 0;
	}
      // ahora los bits del numero
     x = 1 << bits;
     for (i=0;i<bits;i++)
	{ if (B->last & (1<<(B->bpos++))) x |= 1 << i;
	  if (B->bpos == W)
	     { B->last = B->stream[B->pos++];
	       B->bpos = 0;
	     }
	}
     return x-1;
   }

   // cierra la escritura y entrega el nro de bytes y un puntero al array

uchar *closebits (bitstream B, int *n)

   { uchar *ret = (uchar*)B->stream;
     B->stream[B->pos] = B->last;
     *n = (1+B->pos) * W / 8;
     free (B);
     return ret;
   }


